/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.feature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.charm.world.decorator.inner.VillageInnerDecorator;
import svenhjol.charm.world.decorator.outer.Barrels;
import svenhjol.charm.world.decorator.outer.Crops;
import svenhjol.charm.world.decorator.outer.Erosion;
import svenhjol.charm.world.decorator.outer.Flowers;
import svenhjol.charm.world.decorator.outer.Lights;
import svenhjol.charm.world.decorator.outer.Mobs;
import svenhjol.charm.world.decorator.outer.Mushrooms;
import svenhjol.charm.world.decorator.outer.Pumpkins;
import svenhjol.charm.world.decorator.outer.Trees;
import svenhjol.meson.Feature;
import svenhjol.meson.Meson;
import svenhjol.meson.decorator.MesonOuterDecorator;
import svenhjol.meson.event.StructureEventBase;
import svenhjol.meson.helper.WorldHelper;

public class VillageDecorations
extends Feature {
    public static boolean armorStands;
    public static boolean torches;
    public static boolean beds;
    public static boolean storage;
    public static boolean itemFrames;
    public static boolean functionalBlocks;
    public static boolean decorativeBlocks;
    public static boolean carpet;
    public static double cropsChance;
    public static double flowersChance;
    public static double lightsChance;
    public static double mobsChance;
    public static double barrelsChance;
    public static double pumpkinsChance;
    public static double treesChance;
    public static double mushroomsChance;
    public static boolean treesHaveVines;
    public static boolean zombieVillageErosion;
    public static boolean vanillaTools;
    public static double golemsWeight;
    public static double barrelsWeight;
    public static double pumpkinsWeight;
    public static double mobsWeight;
    public static int erosionDamage;
    public static float common;
    public static float uncommon;
    public static float valuable;
    public static float rare;
    public static Map<Integer, Map<ChunkPos, Long>> villageChunks;
    public static List<ChunkPos> villageInfested;

    @Override
    public String getDescription() {
        return "Improves village aesthetics with internal and external decoration.\nHouses and huts are populated with functional and decorative blocks according to a career/profession.\nVillage area can have more trees, flowers, crops, mobs and lights.";
    }

    @Override
    public void configure() {
        super.configure();
        common = (float)this.propDouble("Common chance", "Chance (out of 1.0) of items and blocks considered 'common' to spawn.", 0.9);
        uncommon = (float)this.propDouble("Uncommon chance", "Chance (out of 1.0) of items and blocks considered 'uncommon' to spawn.", 0.35);
        valuable = (float)this.propDouble("Valuable chance", "Chance (out of 1.0) of items and blocks considered 'valuable' to spawn.", 0.05);
        rare = (float)this.propDouble("Rare chance", "Chance (out of 1.0) of items and blocks considered 'rare' to spawn.", 0.005);
        armorStands = this.propBoolean("Armor Stands", "Armor Stands appear in village houses.", true);
        torches = this.propBoolean("Torches", "Torches appear in village houses and around fields to stop water freezing.", true);
        beds = this.propBoolean("Beds", "Beds appear in village houses.", true);
        storage = this.propBoolean("Storage", "Chests, crates and barrels (if enabled) appear in village houses, with loot specific to the house theme.", true);
        itemFrames = this.propBoolean("Item Frames", "Item frames appear on the walls of village houses, with items specific to the house theme.", true);
        functionalBlocks = this.propBoolean("Functional Blocks", "Functional / Interactive blocks appear in village houses, such as anvils, cauldrons and crafting tables.", true);
        decorativeBlocks = this.propBoolean("Decorative Blocks", "Decorative blocks appear in village houses, such as bookshelves, polished stone and planks.", true);
        carpet = this.propBoolean("Carpet", "Coloured rugs appear in village houses and on the top of the village well.", true);
        cropsChance = this.propDouble("Crops outside", "Chance (out of 1.0) of a village having tilled soil, crops and water wells within its boundary.", 0.1);
        flowersChance = this.propDouble("Flowers outside", "Chance (out of 1.0) of a village having more flowers (up to 3 types chosen based on village seed) within its boundary.", 0.9);
        lightsChance = this.propDouble("Lights outside", "Chance (out of 1.0) of a village having torches and lanterns scattered within its boundary.", 0.8);
        mobsChance = this.propDouble("Mobs outside", "Chance (out of 1.0) of a village having more dogs, cats and golems within its boundary.\nIf the village is in a snowy biome, this option lets snow golems spawn.", 0.75);
        barrelsChance = this.propDouble("Barrels and composters outside", "Chance (out of 1.0) of a village having barrels containing farming-related loot and composters scattered within its boundary.", 0.6);
        pumpkinsChance = this.propDouble("Pumpkins outside", "Chance (out of 1.0) of a village having pumpkins (and rarely melons) scattered within its boundary.", 0.6);
        treesChance = this.propDouble("Trees outside", "Chance (out of 1.0) of a village having different types of trees spawn within its boundary.", 0.75);
        mushroomsChance = this.propDouble("Mushrooms outside", "Chance (out of 1.0) of a village having mushrooms spawn, including large mushrooms, within its boundary.", 0.75);
        golemsWeight = this.propDouble("Extra golem weight", "Chance (out of 1.0) of a chunk within the village boundary spawning a golem.\nThis is only valid if the 'Mobs outside' config option allows it.", 0.1);
        barrelsWeight = this.propDouble("Extra barrels weight", "Chance (out of 1.0) of a chunk within the village boundary spawning a barrel.\nThis is only valid if the 'Barrels outside' config option allows it.", 0.7);
        pumpkinsWeight = this.propDouble("Extra pumpkins weight", "Chance (out of 1.0) of a chunk within the village boundary spawning some pumpkins.\nThis is only valid if the 'Pumpkins outside' config option allows it.", 0.7);
        mobsWeight = this.propDouble("Extra mobs weight", "Chance (out of 1.0) of a chunk allowing any kind of mob generation.\nThe greater the chance, the more likely a mob will be considered to spawn.\nThis is only valid is the 'Mobs outside' config option allows it.", 0.75);
        treesHaveVines = this.propBoolean("Trees can have vines", "If true, trees that spawn within the village boundary can have vines hanging from them.\nThis is only valid if the 'Trees outside' config option allows it.\nNOTE: chance for trees to spawn with cocoa beans when vines are enabled.", false);
        zombieVillageErosion = this.propBoolean("Zombie villages are eroded", "If true, zombie villages have damaged and eroded buildings and structures.", true);
        erosionDamage = this.propInt("Zombie village erosion damage", "Number of passes that the generator will erode structures in a zombie village chunk.", 512);
        vanillaTools = this.propBoolean("Vanilla tools in frames and stands", "If true, vanilla tools can spawn in item frames and armor stands.\nThis is only valid if the 'Item frames' and 'Armor stands' config option allows it.", true);
    }

    @SubscribeEvent
    public void onPopulate(PopulateChunkEvent.Populate event) {
        if (event != null && event.isHasVillageGenerated()) {
            World world = event.getWorld();
            ChunkPos chunk = new ChunkPos(event.getChunkX(), event.getChunkZ());
            int dim = world.field_73011_w.getDimension();
            if (!villageChunks.containsKey(dim)) {
                villageChunks.put(dim, new HashMap());
            }
            if (villageChunks.isEmpty() || villageChunks.get(dim).isEmpty() || villageChunks.get(dim).get(chunk) == null) {
                long seed = WorldHelper.getNearestVillageSeed(world, new BlockPos(chunk.field_77276_a << 4, 0, chunk.field_77275_b << 4));
                if (seed == 0L) {
                    Meson.debug("Failed to get the seed for the nearest village...");
                    return;
                }
                villageChunks.get(dim).put(chunk, seed);
            }
        }
    }

    @SubscribeEvent
    public void onDecorate(DecorateBiomeEvent.Decorate event) {
        int dim = event.getWorld().field_73011_w.getDimension();
        if (villageChunks.containsKey(dim) && villageChunks.get(dim).get(event.getChunkPos()) != null && event.getType().equals((Object)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            World world = event.getWorld();
            ChunkPos chunk = event.getChunkPos();
            BlockPos pos = new BlockPos(chunk.field_77276_a << 4, 0, chunk.field_77275_b << 4);
            Random eventRand = event.getRand();
            Random rand = new Random();
            long villageSeed = villageChunks.get(dim).get(chunk);
            rand.setSeed(villageSeed);
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            for (ChunkPos c : villageChunks.get(dim).keySet()) {
                if (villageChunks.get(dim).get(c) != villageSeed) continue;
                chunks.add(c);
            }
            ArrayList<MesonOuterDecorator> decorators = new ArrayList<MesonOuterDecorator>();
            if ((double)rand.nextFloat() <= flowersChance) {
                decorators.add(new Flowers(world, pos, rand, chunks));
            }
            if ((double)rand.nextFloat() <= lightsChance) {
                decorators.add(new Lights(world, pos, eventRand, chunks));
            }
            if ((double)rand.nextFloat() <= mobsChance) {
                decorators.add(new Mobs(world, pos, eventRand, chunks));
            }
            if ((double)rand.nextFloat() <= cropsChance) {
                decorators.add(new Crops(world, pos, eventRand, chunks));
            }
            if ((double)rand.nextFloat() <= barrelsChance) {
                decorators.add(new Barrels(world, pos, eventRand, chunks));
            }
            if ((double)rand.nextFloat() <= pumpkinsChance) {
                decorators.add(new Pumpkins(world, pos, eventRand, chunks));
            }
            if ((double)rand.nextFloat() <= treesChance) {
                decorators.add(new Trees(world, pos, eventRand, chunks));
            }
            if ((double)rand.nextFloat() <= mushroomsChance) {
                decorators.add(new Mushrooms(world, pos, eventRand, chunks));
            }
            if (zombieVillageErosion && villageInfested.contains(chunk)) {
                decorators.add(new Erosion(world, pos, rand, chunks));
            }
            decorators.forEach(MesonOuterDecorator::generate);
            villageChunks.get(dim).remove(chunk);
        }
    }

    @SubscribeEvent
    public void onAddComponentParts(StructureEventBase.Post event) {
        if (event.getComponent() instanceof StructureVillagePieces.Village && !event.getWorld().field_72995_K) {
            World world = event.getWorld();
            StructureBoundingBox box = event.getBox();
            StructureVillagePieces.Village component = (StructureVillagePieces.Village)event.getComponent();
            VillageInnerDecorator decorator = null;
            if (component.getClass() == StructureVillagePieces.Church.class) {
                decorator = new VillageInnerDecorator.Church(component, world, box);
            }
            if (component.getClass() == StructureVillagePieces.Field2.class) {
                decorator = new VillageInnerDecorator.Field1(component, world, box);
            }
            if (component.getClass() == StructureVillagePieces.Field1.class) {
                decorator = new VillageInnerDecorator.Field2(component, world, box);
            }
            if (component.getClass() == StructureVillagePieces.Hall.class) {
                decorator = new VillageInnerDecorator.Hall(component, world, box);
            }
            if (component.getClass() == StructureVillagePieces.House1.class) {
                decorator = new VillageInnerDecorator.House1(component, world, box);
            }
            if (component.getClass() == StructureVillagePieces.House2.class) {
                decorator = new VillageInnerDecorator.House2(component, world, box);
            }
            if (component.getClass() == StructureVillagePieces.House3.class) {
                decorator = new VillageInnerDecorator.House3(component, world, box);
            }
            if (component.getClass() == StructureVillagePieces.House4Garden.class) {
                decorator = new VillageInnerDecorator.House4(component, world, box);
            }
            if (component.getClass() == StructureVillagePieces.WoodHut.class) {
                decorator = new VillageInnerDecorator.WoodHut(component, world, box);
            }
            if (component instanceof StructureVillagePieces.Well) {
                decorator = new VillageInnerDecorator.Well(component, world, box);
            }
            if (decorator != null) {
                if (decorator.isZombieInfested()) {
                    villageInfested.add(decorator.getChunkPos());
                }
                decorator.generate();
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean hasTerrainSubscriptions() {
        return true;
    }

    static {
        common = 0.88f;
        uncommon = 0.35f;
        valuable = 0.05f;
        rare = 0.005f;
        villageChunks = new HashMap<Integer, Map<ChunkPos, Long>>();
        villageInfested = new ArrayList<ChunkPos>();
    }
}

